###################################################
### code chunk number : set your work directory
###################################################
## 
## Firstly, set your work directory to contain "main_real_data.R".
## Secondly, make sure there is a folder named "figure"
## in the same directory of "main_real_data.R".
##


####################################################
### code chunk number : A Real Data Example: szc300_20190304
####################################################
##
##
rm(list=ls(all=TRUE))
source("subfunctions.R")
library(gsl)

data = read.csv("data/szc300_20190304.csv", header = TRUE)
y = data[, 4] ## y is the current price.
xx = 1 / y
write(xx, file = "data/x_20190304.txt")
L_x = length(xx); L_x
n = L_x - 1; n
x = xx[1:n]
x_np1 = xx[n + 1]


## 
## Histogram
## 
dev.new()
hist(y, probability = FALSE, breaks = -1:(max(y) + 1),
    main = paste("Histogram of" , "y"), xlab = "y", sub = "(a)")
savePlot(filename = "figure/U-IG_Histogram_y_real_szc300_20190304", type = c("pdf"))

dev.new()
hist(xx, probability = FALSE, 
    main = paste("Histogram of" , "x"), xlab = "x", sub = "(b)")
savePlot(filename = "figure/U-IG_Histogram_x_real_szc300_20190304", type = c("pdf"))


## 
## Moment estimators
## 
alpha_1_beta_1 = Moment_estimators(x)
alpha_1 = alpha_1_beta_1[1]; alpha_1
beta_1 = alpha_1_beta_1[2]; beta_1

## KS test
ks_test_1 = ks.test(x, "p_U_IG_alpha_Beta", alpha_1, beta_1); ks_test_1

## Compute_Estimator_PESL_new
res_moment = Compute_Estimator_PESL_new(alpha = alpha_1, beta = beta_1, x_np1); res_moment


## 
## run real_data section in Xshell
## 

## 
## real_data
## 
# cd /BIGDATA1/cqu_yyzhang_1/MATLAB/work/U_IG
# yhbatch -N 1 -p rhenv main_real_data_MLE_20190304.sh
# yhq -a

# After the computations in the supercomputer, we can obtain alpha_2_beta_2.


##
## MLE
## The MLE is very sensitive to the initial guess. 
## The moment estimator is usually a good initial guess.
##
alpha_2_beta_2 = c(6.2835, 1.0189) ## computed from Matlab
alpha_2 = alpha_2_beta_2[1]; alpha_2
beta_2 = alpha_2_beta_2[2]; beta_2

## KS test
ks_test_2 = ks.test(x, "p_U_IG_alpha_Beta", alpha_2, beta_2); ks_test_2

## Compute_Estimator_PESL_new
res_MLE = Compute_Estimator_PESL_new(alpha = alpha_2, beta = beta_2, x_np1); res_MLE


